<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*/

/** */
require_once 'entity.php';
require_once 'message.php';
require_once 'folder.php';

/**
* @author M. Gibbs <gibbs_margaret@bah.com>
* @package direct-as-a-service
* @subpackage models
*/
class Mailbox extends Entity {
	static $table = 'users';	
	static $primary_key = 'user_id';
	

	protected static $_relationships = array( /*'folder' => array('type' => 'has_many'),
											  'message' => array('type' => 'has_many'),
											  'inbox_message' => array( 'type' => 'has_many', 'model' => 'message',  'condition' => 'folder_id IS NULL AND sent=0 AND draft=0 AND archived=0'),
											  'archived_message' => array( 'type' => 'has_many', 'model' => 'message', 'condition' => 'archived=1'),
											  'sent_message' => array( 'type' => 'has_many', 'model' => 'message', 'condition' => 'sent=1'),
											  'draft' => array( 'type' => 'has_many', 'model' => 'message', 'condition' => 'draft=1 AND archived=0'),
											  'user' => array( 'type' => 'belongs_to', 'related_foreign_key' => 'name', 'key_for_relationship' => 'username' ),*/
											 );
											 										
	
	
	
	function name(){ return $this->user_name; }
	
	function is_group(){ return $this->user_is_group; }
												  
												   
	function messages($conditions = array(), $key_by=null){
		if(!is_array($conditions)) return $this->error->should_be_an_array($conditions);
		if(!is_null($key_by) && !$this->is->nonempty_string($key_by)) return $this->error->should_be_a_nonempty_string($key_by);
		
		$conditions['mailbox'] = $this->name;
		return Message::find($conditions, $key_by);
	}
				
	function folders($conditions = array(), $key_by=null){
		if(!is_array($conditions)) return $this->error->should_be_an_array($conditions);
		if(!is_null($key_by) && !$this->is->nonempty_string($key_by)) return $this->error->should_be_a_nonempty_string($key_by);
		
		$conditions['mailbox'] = $this->name;
		return Folder::find($conditions, $key_by);
	}			
												  

	/** 
	* The email address for this mailbox.
	* @return string
	*/
	public function email_address(){
		if($this->property_is_empty('user_name')) return '';
		return $this->user_name.'@'.DIRECT_DOMAIN;
	}	
	
/////////////////////
// STATIC FUNCTIONS
/////////////////////
	
	public static function find_by_email_address($address){
		if(!get_instance()->is->string_like_a_direct_address($address)) return get_instance()->error->should_be_a_direct_address($address);
		$user_name = strip_from_end('@'.DIRECT_DOMAIN, $address);
		return static::find_one( compact('user_name') );
	}
	
	public static function find_from_session(){
		$mailbox_group = get_instance()->session->userdata('mailbox_group');
		if(empty($mailbox_group)) $mailbox_group = get_instance()->session->userdata('username');
		if(empty($mailbox_group)) return false;
		
		$CI = get_instance();
		if(isset($CI->mailbox) && Mailbox::is_an_entity($CI->mailbox) && $CI->mailbox->name == $mailbox_group)
			return $CI->mailbox; //skip the db query
		
		return Mailbox::find_one(array('user_name' => $mailbox_group));
	}
	
}
